import { supabaseServer } from "@/lib/supabase/server";
import type { Role } from "@/server/types";

export async function getProfile() {
  const supabase = supabaseServer();
  const { data: { user } } = await supabase.auth.getUser();
  if (!user) return { user: null, role: null as Role | null };

  const { data: profile } = await supabase
    .from("profiles")
    .select("role, email, full_name")
    .eq("user_id", user.id)
    .maybeSingle();

  const role = (profile?.role ?? "borrower_personal") as Role;
  return { user, role, profile };
}
