import { cookies } from "next/headers";
import { createServerClient } from "@supabase/ssr";
import { mustEnv } from "@/lib/env";

export function supabaseServer() {
  const cookieStore = cookies();
  return createServerClient(
    mustEnv("NEXT_PUBLIC_SUPABASE_URL"),
    mustEnv("NEXT_PUBLIC_SUPABASE_ANON_KEY"),
    {
      cookies: {
        getAll() {
          return cookieStore.getAll();
        },
        setAll(cookiesToSet) {
          try {
            cookiesToSet.forEach(({ name, value, options }) =>
              cookieStore.set(name, value, options)
            );
          } catch {
            // server components may not be able to set cookies
          }
        },
      },
    }
  );
}
