import { cn } from "./cn";

type Props = React.ButtonHTMLAttributes<HTMLButtonElement> & {
  variant?: "primary" | "secondary" | "ghost" | "danger";
};

export function Button({ className, variant = "primary", ...props }: Props) {
  const base =
    "inline-flex items-center justify-center rounded-xl2 px-4 py-2 text-sm font-medium transition active:scale-[0.99] disabled:opacity-60 disabled:cursor-not-allowed";
  const v =
    variant === "primary"
      ? "bg-thebe-blue2 text-white hover:brightness-110 shadow-soft"
      : variant === "secondary"
      ? "bg-white text-thebe-text border border-thebe-border hover:bg-slate-50"
      : variant === "danger"
      ? "bg-thebe-danger text-white hover:brightness-110 shadow-soft"
      : "bg-transparent text-thebe-blue2 hover:bg-blue-50";
  return <button className={cn(base, v, className)} {...props} />;
}
