import { cn } from "./cn";

type Props = React.HTMLAttributes<HTMLSpanElement> & {
  tone?: "blue" | "green" | "amber" | "red" | "gray";
};

export function Badge({ className, tone = "gray", ...props }: Props) {
  const t =
    tone === "blue"
      ? "bg-blue-50 text-thebe-blue border-blue-100"
      : tone === "green"
      ? "bg-green-50 text-thebe-success border-green-100"
      : tone === "amber"
      ? "bg-amber-50 text-thebe-warn border-amber-100"
      : tone === "red"
      ? "bg-red-50 text-thebe-danger border-red-100"
      : "bg-slate-50 text-slate-700 border-slate-100";
  return (
    <span
      className={cn(
        "inline-flex items-center rounded-full border px-2.5 py-1 text-xs font-medium",
        t,
        className
      )}
      {...props}
    />
  );
}
