import Link from "next/link";
import { Button } from "@/components/ui/Button";

export function NavBar() {
  return (
    <header className="border-b border-thebe-border bg-white/70 backdrop-blur">
      <div className="container flex items-center justify-between py-4">
        <Link href="/" className="flex items-center gap-2">
          <div className="h-9 w-9 rounded-xl2 bg-gradient-to-br from-thebe-blue to-thebe-blue2 shadow-soft" />
          <div className="leading-tight">
            <div className="text-sm font-semibold">Thebe</div>
            <div className="text-xs text-slate-500 -mt-0.5">Credit Marketplace</div>
          </div>
        </Link>
        <nav className="hidden md:flex items-center gap-6 text-sm text-slate-600">
          <Link href="/loan-types" className="hover:text-thebe-blue2">Loan Types</Link>
          <Link href="/how-it-works" className="hover:text-thebe-blue2">How it Works</Link>
          <Link href="/knowledge" className="hover:text-thebe-blue2">Knowledge</Link>
          <Link href="/rates-fees" className="hover:text-thebe-blue2">Rates & Fees</Link>
          <Link href="/contact" className="hover:text-thebe-blue2">Contact</Link>
        </nav>
        <div className="flex items-center gap-2">
          <Link href="/login"><Button variant="ghost">Sign in</Button></Link>
          <Link href="/register"><Button>Get started</Button></Link>
        </div>
      </div>
    </header>
  );
}
