import Link from "next/link";
import { Badge } from "@/components/ui/Badge";

type Props = {
  title: string;
  roleLabel: string;
  nav: Array<{ href: string; label: string; }>;
  children: React.ReactNode;
};

export function AppShell({ title, roleLabel, nav, children }: Props) {
  return (
    <div className="min-h-screen bg-thebe-bg">
      <div className="border-b border-thebe-border bg-white/70 backdrop-blur">
        <div className="container flex items-center justify-between py-4">
          <Link href="/" className="flex items-center gap-2">
            <div className="h-9 w-9 rounded-xl2 bg-gradient-to-br from-thebe-blue to-thebe-blue2 shadow-soft" />
            <div className="leading-tight">
              <div className="text-sm font-semibold">{title}</div>
              <div className="text-xs text-slate-500 -mt-0.5">Thebe</div>
            </div>
          </Link>
          <Badge tone="blue">{roleLabel}</Badge>
        </div>
      </div>

      <div className="container grid grid-cols-1 md:grid-cols-[260px_1fr] gap-6 py-6">
        <aside className="rounded-xl2 bg-white border border-thebe-border shadow-soft p-4 h-fit">
          <div className="text-xs uppercase tracking-wider text-slate-500 mb-3">Menu</div>
          <div className="flex flex-col gap-1">
            {nav.map((n) => (
              <Link
                key={n.href}
                href={n.href}
                className="rounded-xl2 px-3 py-2 text-sm text-slate-700 hover:bg-slate-50"
              >
                {n.label}
              </Link>
            ))}
            <Link
              href="/logout"
              className="rounded-xl2 px-3 py-2 text-sm text-red-600 hover:bg-red-50 mt-2"
            >
              Sign out
            </Link>
          </div>
        </aside>

        <main className="min-w-0">{children}</main>
      </div>
    </div>
  );
}
