import { Card } from "@/components/ui/Card";
import { Badge } from "@/components/ui/Badge";
import Link from "next/link";
import { supabaseServer } from "@/lib/supabase/server";

export default async function BorrowerDashboard() {
  const supabase = supabaseServer();
  const { data: { user } } = await supabase.auth.getUser();

  const { data: apps } = await supabase
    .from("applications")
    .select("id,status,amount_requested,term_requested,created_at")
    .eq("user_id", user?.id ?? "")
    .order("created_at", { ascending: false })
    .limit(5);

  return (
    <div className="space-y-6">
      <Card>
        <div className="flex items-center justify-between gap-3">
          <div>
            <div className="text-xl font-semibold">Welcome to Thebe</div>
            <div className="text-sm text-slate-600 mt-1">Your dashboard for applications, offers, loans and payments.</div>
          </div>
          <Link href="/app/apply" className="text-thebe-blue2 hover:underline text-sm">Start a new application</Link>
        </div>
      </Card>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        <Card>
          <div className="text-sm text-slate-500">KYC</div>
          <div className="mt-2 text-lg font-semibold">Required</div>
          <div className="mt-1 text-sm text-slate-600">Omang + proof of address before submission.</div>
          <Link href="/app/account" className="mt-3 inline-block text-sm text-thebe-blue2 hover:underline">Go to KYC</Link>
        </Card>
        <Card>
          <div className="text-sm text-slate-500">Offers</div>
          <div className="mt-2 text-lg font-semibold">Compare</div>
          <div className="mt-1 text-sm text-slate-600">APR, fees, term and monthly estimate.</div>
          <Link href="/app/offers" className="mt-3 inline-block text-sm text-thebe-blue2 hover:underline">View offers</Link>
        </Card>
        <Card>
          <div className="text-sm text-slate-500">Payments</div>
          <div className="mt-2 text-lg font-semibold">All types</div>
          <div className="mt-1 text-sm text-slate-600">Card, mobile money, bank transfer and manual proof.</div>
          <Link href="/app/payments" className="mt-3 inline-block text-sm text-thebe-blue2 hover:underline">Go to payments</Link>
        </Card>
      </div>

      <Card>
        <div className="flex items-center justify-between">
          <div className="text-sm font-semibold">Recent applications</div>
          <Link href="/app/applications" className="text-sm text-thebe-blue2 hover:underline">See all</Link>
        </div>
        <div className="mt-4 space-y-3">
          {(apps ?? []).length === 0 ? (
            <div className="text-sm text-slate-600">No applications yet. Start one from the Apply page.</div>
          ) : (
            (apps ?? []).map((a) => (
              <div key={a.id} className="flex items-center justify-between rounded-xl2 border border-thebe-border bg-slate-50 px-4 py-3">
                <div>
                  <div className="text-sm font-medium">Application #{String(a.id).slice(0, 8)}</div>
                  <div className="text-xs text-slate-500">Amount: P{a.amount_requested} • Term: {a.term_requested} months</div>
                </div>
                <Badge tone="blue">{a.status}</Badge>
              </div>
            ))
          )}
        </div>
      </Card>
    </div>
  );
}
