import { NextResponse } from "next/server";
import { supabaseServer } from "@/lib/supabase/server";
import { routeApplication } from "@/server/routing/routeApplication";

export async function POST(req: Request) {
  const form = await req.formData();
  const application_id = String(form.get("application_id") ?? "");
  if (!application_id) return NextResponse.json({ error: "Missing application_id" }, { status: 400 });

  const supabase = supabaseServer();
  const { data: { user } } = await supabase.auth.getUser();
  if (!user) return NextResponse.json({ error: "Not authenticated" }, { status: 401 });

  // Ensure borrower owns it and is draft
  const { data: app } = await supabase
    .from("applications")
    .select("id,status")
    .eq("id", application_id)
    .eq("user_id", user.id)
    .maybeSingle();

  if (!app) return NextResponse.json({ error: "Not found" }, { status: 404 });
  if (app.status !== "draft") return NextResponse.json({ error: "Already submitted" }, { status: 400 });

  const topN = Number(process.env.THEBE_DEFAULT_ROUTE_COUNT ?? "5");
  await routeApplication(application_id, topN);

  return NextResponse.redirect(new URL(`/app/applications/${application_id}`, req.url));
}
