import Link from "next/link";
import { NavBar } from "@/components/NavBar";
import { Card } from "@/components/ui/Card";

export default function Page() {
  return (
    <div className="min-h-screen bg-thebe-bg">
      <NavBar />
      <div className="container py-10">
        <Card>
          <h1 className="text-2xl font-semibold">Loan Types</h1>
          <p className="mt-3 text-slate-600">Personal, Auto, Education, Home, Credit Card, Line of Credit and Purchase Order Finance. Each issuer defines eligibility and pricing bands. Thebe matches and routes accordingly.</p>
          <div className="mt-5 text-sm">
            <Link href="/" className="text-thebe-blue2 hover:underline">Back home</Link>
          </div>
        </Card>
      </div>
    </div>
  );
}
