# Thebe (Botswana) — Credit Marketplace (Rapid Scaffold B)

**What this is**
- A modernized, Blue-Trust fintech web app scaffold for **Thebe** (Botswana-first),
  implementing the agreed modules: borrower portal, issuer portal, admin oversight,
  multi-issuer routing, serious KYC doc vault, payments (incl. manual proof), and mixed monetization hooks.

**Stack (fastest to ship)**
- Next.js (App Router) + TypeScript
- TailwindCSS
- Supabase (Postgres + Auth + Storage) for rapid deployment

## 1) Quick start (local)
1. Create a Supabase project.
2. In Supabase: Storage → create bucket `thebe-docs` (private).
3. Run SQL migration: `supabase/migrations/0001_thebe_schema.sql` in Supabase SQL editor.
4. Copy `.env.example` to `.env.local` and fill values.
5. Install and run:
   ```bash
   npm install
   npm run dev
   ```
6. Visit:
   - Public: http://localhost:3000
   - Borrower: http://localhost:3000/app
   - Issuer: http://localhost:3000/issuer
   - Admin: http://localhost:3000/admin

## 2) Roles
- `borrower_personal`, `borrower_business`
- `issuer_user`
- `admin`

Roles are stored in `public.profiles.role` and enforced by middleware + server checks.

## 3) Seed (recommended)
Create your first admin user:
- Sign up normally at `/register`
- In Supabase SQL, set your role:
  ```sql
  update public.profiles set role='admin' where email='you@example.com';
  ```

Create an issuer and issuer user:
- Sign up a user, set role to `issuer_user`
- Insert an issuer record and link issuer user to issuer:
  ```sql
  insert into public.issuers (name,status,tier) values ('Example Lender','approved','standard') returning id;
  insert into public.issuer_users (issuer_id,user_id,role) values ('<issuer_id>','<auth_user_uuid>','manager');
  ```
- Add issuer products in `issuer_products`.

## 4) Payments
- This scaffold includes **manual proof** upload and storage.
- For automated rails (cards / mobile money / EFT), implement in `app/api/payments/initiate/route.ts` and webhooks.
  The app is designed so settlement goes to issuer accounts (Thebe never custodians loan funds).

## 5) Routing
- When a borrower submits an application, Thebe routes it to top N issuers that match hard rules:
  - loan type, amount, term, active issuer product, issuer approved
- Routing logic: `src/server/routing/routeApplication.ts`

## 6) Security notes (important)
- Storage bucket must be private.
- Signed URLs are used for downloads.
- RLS policies are included but you should review with your compliance counsel.
